/*
  File autogenerated by gengetopt version 2.22.1
  generated with the following command:
  gengetopt -S -i ptrn_collvsnoise_cmdline.ggo -F ptrn_collvsnoise_cmdline -f ptrn_collvsnoise_parser -a ptrn_collvsnoise_cmd_struct 

  The developers of gengetopt consider the fixed text that goes in all
  gengetopt output files to be in the public domain:
  we make no copyright claims on it.
*/

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "getopt.h"

#include "ptrn_collvsnoise_cmdline.h"

const char *ptrn_collvsnoise_cmd_struct_purpose = "";

const char *ptrn_collvsnoise_cmd_struct_usage = "Usage: netgauge-collvsnoise [OPTIONS]...";

const char *ptrn_collvsnoise_cmd_struct_description = "";

const char *ptrn_collvsnoise_cmd_struct_help[] = {
  "  -h, --help               Print help and exit",
  "  -V, --version            Print version and exit",
  "  -x, --pattern=pattern    pattern",
  "  -s, --datasize=datasize  size of the collective data transfer  \n                             (default=`8-8')",
  "  -c, --commsize=STRING    collective communicator sizes  (default=`2-')",
  "  -n, --nochangecomm       don't change communicator during run  (default=off)",
    0
};

typedef enum {ARG_NO
  , ARG_FLAG
  , ARG_STRING
} ptrn_collvsnoise_parser_arg_type;

static
void clear_given (struct ptrn_collvsnoise_cmd_struct *args_info);
static
void clear_args (struct ptrn_collvsnoise_cmd_struct *args_info);

static int
ptrn_collvsnoise_parser_internal (int argc, char * const *argv, struct ptrn_collvsnoise_cmd_struct *args_info,
                        struct ptrn_collvsnoise_parser_params *params, const char *additional_error);

static int
ptrn_collvsnoise_parser_required2 (struct ptrn_collvsnoise_cmd_struct *args_info, const char *prog_name, const char *additional_error);
struct line_list
{
  char * string_arg;
  struct line_list * next;
};

static struct line_list *cmd_line_list = 0;
static struct line_list *cmd_line_list_tmp = 0;

static void
free_cmd_list(void)
{
  /* free the list of a previous call */
  if (cmd_line_list)
    {
      while (cmd_line_list) {
        cmd_line_list_tmp = cmd_line_list;
        cmd_line_list = cmd_line_list->next;
        free (cmd_line_list_tmp->string_arg);
        free (cmd_line_list_tmp);
      }
    }
}


static char *
gengetopt_strdup (const char *s);

static
void clear_given (struct ptrn_collvsnoise_cmd_struct *args_info)
{
  args_info->help_given = 0 ;
  args_info->version_given = 0 ;
  args_info->pattern_given = 0 ;
  args_info->datasize_given = 0 ;
  args_info->commsize_given = 0 ;
  args_info->nochangecomm_given = 0 ;
}

static
void clear_args (struct ptrn_collvsnoise_cmd_struct *args_info)
{
  args_info->pattern_arg = NULL;
  args_info->pattern_orig = NULL;
  args_info->datasize_arg = gengetopt_strdup ("8-8");
  args_info->datasize_orig = NULL;
  args_info->commsize_arg = gengetopt_strdup ("2-");
  args_info->commsize_orig = NULL;
  args_info->nochangecomm_flag = 0;
  
}

static
void init_args_info(struct ptrn_collvsnoise_cmd_struct *args_info)
{


  args_info->help_help = ptrn_collvsnoise_cmd_struct_help[0] ;
  args_info->version_help = ptrn_collvsnoise_cmd_struct_help[1] ;
  args_info->pattern_help = ptrn_collvsnoise_cmd_struct_help[2] ;
  args_info->datasize_help = ptrn_collvsnoise_cmd_struct_help[3] ;
  args_info->commsize_help = ptrn_collvsnoise_cmd_struct_help[4] ;
  args_info->nochangecomm_help = ptrn_collvsnoise_cmd_struct_help[5] ;
  
}

void
ptrn_collvsnoise_parser_print_version (void)
{
  printf ("%s %s\n", PTRN_COLLVSNOISE_PARSER_PACKAGE, PTRN_COLLVSNOISE_PARSER_VERSION);
}

static void print_help_common(void) {
  ptrn_collvsnoise_parser_print_version ();

  if (strlen(ptrn_collvsnoise_cmd_struct_purpose) > 0)
    printf("\n%s\n", ptrn_collvsnoise_cmd_struct_purpose);

  if (strlen(ptrn_collvsnoise_cmd_struct_usage) > 0)
    printf("\n%s\n", ptrn_collvsnoise_cmd_struct_usage);

  printf("\n");

  if (strlen(ptrn_collvsnoise_cmd_struct_description) > 0)
    printf("%s\n\n", ptrn_collvsnoise_cmd_struct_description);
}

void
ptrn_collvsnoise_parser_print_help (void)
{
  int i = 0;
  print_help_common();
  while (ptrn_collvsnoise_cmd_struct_help[i])
    printf("%s\n", ptrn_collvsnoise_cmd_struct_help[i++]);
}

void
ptrn_collvsnoise_parser_init (struct ptrn_collvsnoise_cmd_struct *args_info)
{
  clear_given (args_info);
  clear_args (args_info);
  init_args_info (args_info);
}

void
ptrn_collvsnoise_parser_params_init(struct ptrn_collvsnoise_parser_params *params)
{
  if (params)
    { 
      params->override = 0;
      params->initialize = 1;
      params->check_required = 1;
      params->check_ambiguity = 0;
      params->print_errors = 1;
    }
}

struct ptrn_collvsnoise_parser_params *
ptrn_collvsnoise_parser_params_create(void)
{
  struct ptrn_collvsnoise_parser_params *params = 
    (struct ptrn_collvsnoise_parser_params *)malloc(sizeof(struct ptrn_collvsnoise_parser_params));
  ptrn_collvsnoise_parser_params_init(params);  
  return params;
}

static void
free_string_field (char **s)
{
  if (*s)
    {
      free (*s);
      *s = 0;
    }
}


static void
ptrn_collvsnoise_parser_release (struct ptrn_collvsnoise_cmd_struct *args_info)
{

  free_string_field (&(args_info->pattern_arg));
  free_string_field (&(args_info->pattern_orig));
  free_string_field (&(args_info->datasize_arg));
  free_string_field (&(args_info->datasize_orig));
  free_string_field (&(args_info->commsize_arg));
  free_string_field (&(args_info->commsize_orig));
  
  

  clear_given (args_info);
}


static void
write_into_file(FILE *outfile, const char *opt, const char *arg, char *values[])
{
  if (arg) {
    fprintf(outfile, "%s=\"%s\"\n", opt, arg);
  } else {
    fprintf(outfile, "%s\n", opt);
  }
}


int
ptrn_collvsnoise_parser_dump(FILE *outfile, struct ptrn_collvsnoise_cmd_struct *args_info)
{
  int i = 0;

  if (!outfile)
    {
      fprintf (stderr, "%s: cannot dump options to stream\n", PTRN_COLLVSNOISE_PARSER_PACKAGE);
      return EXIT_FAILURE;
    }

  if (args_info->help_given)
    write_into_file(outfile, "help", 0, 0 );
  if (args_info->version_given)
    write_into_file(outfile, "version", 0, 0 );
  if (args_info->pattern_given)
    write_into_file(outfile, "pattern", args_info->pattern_orig, 0);
  if (args_info->datasize_given)
    write_into_file(outfile, "datasize", args_info->datasize_orig, 0);
  if (args_info->commsize_given)
    write_into_file(outfile, "commsize", args_info->commsize_orig, 0);
  if (args_info->nochangecomm_given)
    write_into_file(outfile, "nochangecomm", 0, 0 );
  

  i = EXIT_SUCCESS;
  return i;
}

int
ptrn_collvsnoise_parser_file_save(const char *filename, struct ptrn_collvsnoise_cmd_struct *args_info)
{
  FILE *outfile;
  int i = 0;

  outfile = fopen(filename, "w");

  if (!outfile)
    {
      fprintf (stderr, "%s: cannot open file for writing: %s\n", PTRN_COLLVSNOISE_PARSER_PACKAGE, filename);
      return EXIT_FAILURE;
    }

  i = ptrn_collvsnoise_parser_dump(outfile, args_info);
  fclose (outfile);

  return i;
}

void
ptrn_collvsnoise_parser_free (struct ptrn_collvsnoise_cmd_struct *args_info)
{
  ptrn_collvsnoise_parser_release (args_info);
}

/** @brief replacement of strdup, which is not standard */
char *
gengetopt_strdup (const char *s)
{
  char *result = NULL;
  if (!s)
    return result;

  result = (char*)malloc(strlen(s) + 1);
  if (result == (char*)0)
    return (char*)0;
  strcpy(result, s);
  return result;
}

int
ptrn_collvsnoise_parser (int argc, char * const *argv, struct ptrn_collvsnoise_cmd_struct *args_info)
{
  return ptrn_collvsnoise_parser2 (argc, argv, args_info, 0, 1, 1);
}

int
ptrn_collvsnoise_parser_ext (int argc, char * const *argv, struct ptrn_collvsnoise_cmd_struct *args_info,
                   struct ptrn_collvsnoise_parser_params *params)
{
  int result;
  result = ptrn_collvsnoise_parser_internal (argc, argv, args_info, params, NULL);

  if (result == EXIT_FAILURE)
    {
      ptrn_collvsnoise_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
ptrn_collvsnoise_parser2 (int argc, char * const *argv, struct ptrn_collvsnoise_cmd_struct *args_info, int override, int initialize, int check_required)
{
  int result;
  struct ptrn_collvsnoise_parser_params params;
  
  params.override = override;
  params.initialize = initialize;
  params.check_required = check_required;
  params.check_ambiguity = 0;
  params.print_errors = 1;

  result = ptrn_collvsnoise_parser_internal (argc, argv, args_info, &params, NULL);

  if (result == EXIT_FAILURE)
    {
      ptrn_collvsnoise_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
ptrn_collvsnoise_parser_required (struct ptrn_collvsnoise_cmd_struct *args_info, const char *prog_name)
{
  int result = EXIT_SUCCESS;

  if (ptrn_collvsnoise_parser_required2(args_info, prog_name, NULL) > 0)
    result = EXIT_FAILURE;

  if (result == EXIT_FAILURE)
    {
      ptrn_collvsnoise_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
ptrn_collvsnoise_parser_required2 (struct ptrn_collvsnoise_cmd_struct *args_info, const char *prog_name, const char *additional_error)
{
  int error = 0;

  /* checks for required options */
  if (! args_info->pattern_given)
    {
      fprintf (stderr, "%s: '--pattern' ('-x') option required%s\n", prog_name, (additional_error ? additional_error : ""));
      error = 1;
    }
  
  
  /* checks for dependences among options */

  return error;
}


static char *package_name = 0;

/**
 * @brief updates an option
 * @param field the generic pointer to the field to update
 * @param orig_field the pointer to the orig field
 * @param field_given the pointer to the number of occurrence of this option
 * @param prev_given the pointer to the number of occurrence already seen
 * @param value the argument for this option (if null no arg was specified)
 * @param possible_values the possible values for this option (if specified)
 * @param default_value the default value (in case the option only accepts fixed values)
 * @param arg_type the type of this option
 * @param check_ambiguity @see ptrn_collvsnoise_parser_params.check_ambiguity
 * @param override @see ptrn_collvsnoise_parser_params.override
 * @param no_free whether to free a possible previous value
 * @param multiple_option whether this is a multiple option
 * @param long_opt the corresponding long option
 * @param short_opt the corresponding short option (or '-' if none)
 * @param additional_error possible further error specification
 */
static
int update_arg(void *field, char **orig_field,
               unsigned int *field_given, unsigned int *prev_given, 
               char *value, char *possible_values[], const char *default_value,
               ptrn_collvsnoise_parser_arg_type arg_type,
               int check_ambiguity, int override,
               int no_free, int multiple_option,
               const char *long_opt, char short_opt,
               const char *additional_error)
{
  char *stop_char = 0;
  const char *val = value;
  int found;
  char **string_field;

  stop_char = 0;
  found = 0;

  if (!multiple_option && prev_given && (*prev_given || (check_ambiguity && *field_given)))
    {
      if (short_opt != '-')
        fprintf (stderr, "%s: `--%s' (`-%c') option given more than once%s\n", 
               package_name, long_opt, short_opt,
               (additional_error ? additional_error : ""));
      else
        fprintf (stderr, "%s: `--%s' option given more than once%s\n", 
               package_name, long_opt,
               (additional_error ? additional_error : ""));
      return 1; /* failure */
    }

    
  if (field_given && *field_given && ! override)
    return 0;
  if (prev_given)
    (*prev_given)++;
  if (field_given)
    (*field_given)++;
  if (possible_values)
    val = possible_values[found];

  switch(arg_type) {
  case ARG_FLAG:
    *((int *)field) = !*((int *)field);
    break;
  case ARG_STRING:
    if (val) {
      string_field = (char **)field;
      if (!no_free && *string_field)
        free (*string_field); /* free previous string */
      *string_field = gengetopt_strdup (val);
    }
    break;
  default:
    break;
  };


  /* store the original value */
  switch(arg_type) {
  case ARG_NO:
  case ARG_FLAG:
    break;
  default:
    if (value && orig_field) {
      if (no_free) {
        *orig_field = value;
      } else {
        if (*orig_field)
          free (*orig_field); /* free previous string */
        *orig_field = gengetopt_strdup (value);
      }
    }
  };

  return 0; /* OK */
}


int
ptrn_collvsnoise_parser_internal (int argc, char * const *argv, struct ptrn_collvsnoise_cmd_struct *args_info,
                        struct ptrn_collvsnoise_parser_params *params, const char *additional_error)
{
  int c;	/* Character of the parsed option.  */

  int error = 0;
  struct ptrn_collvsnoise_cmd_struct local_args_info;
  
  int override;
  int initialize;
  int check_required;
  int check_ambiguity;
  
  package_name = argv[0];
  
  override = params->override;
  initialize = params->initialize;
  check_required = params->check_required;
  check_ambiguity = params->check_ambiguity;

  if (initialize)
    ptrn_collvsnoise_parser_init (args_info);

  ptrn_collvsnoise_parser_init (&local_args_info);

  optarg = 0;
  optind = 0;
  opterr = params->print_errors;
  optopt = '?';

  while (1)
    {
      int option_index = 0;

      static struct option long_options[] = {
        { "help",	0, NULL, 'h' },
        { "version",	0, NULL, 'V' },
        { "pattern",	1, NULL, 'x' },
        { "datasize",	1, NULL, 's' },
        { "commsize",	1, NULL, 'c' },
        { "nochangecomm",	0, NULL, 'n' },
        { NULL,	0, NULL, 0 }
      };

      c = getopt_long (argc, argv, "hVx:s:c:n", long_options, &option_index);

      if (c == -1) break;	/* Exit from `while (1)' loop.  */

      switch (c)
        {
        case 'h':	/* Print help and exit.  */
          ptrn_collvsnoise_parser_print_help ();
          ptrn_collvsnoise_parser_free (&local_args_info);
          exit (EXIT_SUCCESS);

        case 'V':	/* Print version and exit.  */
          ptrn_collvsnoise_parser_print_version ();
          ptrn_collvsnoise_parser_free (&local_args_info);
          exit (EXIT_SUCCESS);

        case 'x':	/* pattern.  */
        
        
          if (update_arg( (void *)&(args_info->pattern_arg), 
               &(args_info->pattern_orig), &(args_info->pattern_given),
              &(local_args_info.pattern_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "pattern", 'x',
              additional_error))
            goto failure;
        
          break;
        case 's':	/* size of the collective data transfer.  */
        
        
          if (update_arg( (void *)&(args_info->datasize_arg), 
               &(args_info->datasize_orig), &(args_info->datasize_given),
              &(local_args_info.datasize_given), optarg, 0, "8-8", ARG_STRING,
              check_ambiguity, override, 0, 0,
              "datasize", 's',
              additional_error))
            goto failure;
        
          break;
        case 'c':	/* collective communicator sizes.  */
        
        
          if (update_arg( (void *)&(args_info->commsize_arg), 
               &(args_info->commsize_orig), &(args_info->commsize_given),
              &(local_args_info.commsize_given), optarg, 0, "2-", ARG_STRING,
              check_ambiguity, override, 0, 0,
              "commsize", 'c',
              additional_error))
            goto failure;
        
          break;
        case 'n':	/* don't change communicator during run.  */
        
        
          if (update_arg((void *)&(args_info->nochangecomm_flag), 0, &(args_info->nochangecomm_given),
              &(local_args_info.nochangecomm_given), optarg, 0, 0, ARG_FLAG,
              check_ambiguity, override, 1, 0, "nochangecomm", 'n',
              additional_error))
            goto failure;
        
          break;

        case 0:	/* Long option with no short option */
        case '?':	/* Invalid option.  */
          /* `getopt_long' already printed an error message.  */
          goto failure;

        default:	/* bug: option not considered.  */
          fprintf (stderr, "%s: option unknown: %c%s\n", PTRN_COLLVSNOISE_PARSER_PACKAGE, c, (additional_error ? additional_error : ""));
          abort ();
        } /* switch */
    } /* while */



  if (check_required)
    {
      error += ptrn_collvsnoise_parser_required2 (args_info, argv[0], additional_error);
    }

  ptrn_collvsnoise_parser_release (&local_args_info);

  if ( error )
    return (EXIT_FAILURE);

  return 0;

failure:
  
  ptrn_collvsnoise_parser_release (&local_args_info);
  return (EXIT_FAILURE);
}

static unsigned int
ptrn_collvsnoise_parser_create_argv(const char *cmdline_, char ***argv_ptr, const char *prog_name)
{
  char *cmdline, *p;
  size_t n = 0, j;
  int i;

  if (prog_name) {
    cmd_line_list_tmp = (struct line_list *) malloc (sizeof (struct line_list));
    cmd_line_list_tmp->next = cmd_line_list;
    cmd_line_list = cmd_line_list_tmp;
    cmd_line_list->string_arg = gengetopt_strdup (prog_name);

    ++n;
  }

  cmdline = gengetopt_strdup(cmdline_);
  p = cmdline;

  while (p && strlen(p))
    {
      j = strcspn(p, " \t");
      ++n;
      if (j && j < strlen(p))
        {
          p[j] = '\0';

          cmd_line_list_tmp = (struct line_list *) malloc (sizeof (struct line_list));
          cmd_line_list_tmp->next = cmd_line_list;
          cmd_line_list = cmd_line_list_tmp;
          cmd_line_list->string_arg = gengetopt_strdup (p);

          p += (j+1);
          p += strspn(p, " \t");
        }
      else
        {
          cmd_line_list_tmp = (struct line_list *) malloc (sizeof (struct line_list));
          cmd_line_list_tmp->next = cmd_line_list;
          cmd_line_list = cmd_line_list_tmp;
          cmd_line_list->string_arg = gengetopt_strdup (p);

          break;
        }
    }

  *argv_ptr = (char **) malloc((n + 1) * sizeof(char *));
  cmd_line_list_tmp = cmd_line_list;
  for (i = (n-1); i >= 0; --i)
    {
      (*argv_ptr)[i] = cmd_line_list_tmp->string_arg;
      cmd_line_list_tmp = cmd_line_list_tmp->next;
    }

  (*argv_ptr)[n] = NULL;

  free(cmdline);
  return n;
}

int
ptrn_collvsnoise_parser_string(const char *cmdline, struct ptrn_collvsnoise_cmd_struct *args_info, const char *prog_name)
{
  return ptrn_collvsnoise_parser_string2(cmdline, args_info, prog_name, 0, 1, 1);
}

int
ptrn_collvsnoise_parser_string2(const char *cmdline, struct ptrn_collvsnoise_cmd_struct *args_info, const char *prog_name,
    int override, int initialize, int check_required)
{
  struct ptrn_collvsnoise_parser_params params;

  params.override = override;
  params.initialize = initialize;
  params.check_required = check_required;
  params.check_ambiguity = 0;
  params.print_errors = 1;

  return ptrn_collvsnoise_parser_string_ext(cmdline, args_info, prog_name, &params);
}

int
ptrn_collvsnoise_parser_string_ext(const char *cmdline, struct ptrn_collvsnoise_cmd_struct *args_info, const char *prog_name,
    struct ptrn_collvsnoise_parser_params *params)
{
  char **argv_ptr = 0;
  int result;
  unsigned int argc;
  
  argc = ptrn_collvsnoise_parser_create_argv(cmdline, &argv_ptr, prog_name);
  
  result =
    ptrn_collvsnoise_parser_internal (argc, argv_ptr, args_info, params, 0);
  
  if (argv_ptr)
    {
      free (argv_ptr);
    }

  free_cmd_list();
  
  if (result == EXIT_FAILURE)
    {
      ptrn_collvsnoise_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

