/** @file ptrn_mprobe_cmdline.h
 *  @brief The header file for the command line option parser
 *  generated by GNU Gengetopt version 2.22.1
 *  http://www.gnu.org/software/gengetopt.
 *  DO NOT modify this file, since it can be overwritten
 *  @author GNU Gengetopt by Lorenzo Bettini */

#ifndef PTRN_MPROBE_CMDLINE_H
#define PTRN_MPROBE_CMDLINE_H

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h> /* for FILE */

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#ifndef PTRN_MPROBE_PARSER_PACKAGE
/** @brief the program name */
#define PTRN_MPROBE_PARSER_PACKAGE "netgauge-mprobe"
#endif

#ifndef PTRN_MPROBE_PARSER_VERSION
/** @brief the program version */
#define PTRN_MPROBE_PARSER_VERSION "0.1"
#endif

/** @brief Where the command line options are stored */
struct ptrn_mprobe_cmd_struct
{
  const char *help_help; /**< @brief Print help and exit help description.  */
  const char *version_help; /**< @brief Print version and exit help description.  */
  char * pattern_arg;	/**< @brief pattern.  */
  char * pattern_orig;	/**< @brief pattern original value given at command line.  */
  const char *pattern_help; /**< @brief pattern help description.  */
  int threads_arg;	/**< @brief Number of Threads (default='1').  */
  char * threads_orig;	/**< @brief Number of Threads original value given at command line.  */
  const char *threads_help; /**< @brief Number of Threads help description.  */
  int messages_arg;	/**< @brief Number of Messages (default='10000').  */
  char * messages_orig;	/**< @brief Number of Messages original value given at command line.  */
  const char *messages_help; /**< @brief Number of Messages help description.  */
  int reps_arg;	/**< @brief Number or Repetitions (default='20').  */
  char * reps_orig;	/**< @brief Number or Repetitions original value given at command line.  */
  const char *reps_help; /**< @brief Number or Repetitions help description.  */
  int hostname_flag;	/**< @brief Print hostname (default=off).  */
  const char *hostname_help; /**< @brief Print hostname help description.  */
  int nonblocking_flag;	/**< @brief Use nonblocking receive from all peers in parallel (default=off).  */
  const char *nonblocking_help; /**< @brief Use nonblocking receive from all peers in parallel help description.  */
  int option_arg;	/**< @brief Option: 1=ANY,ANY, 2=src,ANY, 3=ANY,tag, 4=src,tag (default='1').  */
  char * option_orig;	/**< @brief Option: 1=ANY,ANY, 2=src,ANY, 3=ANY,tag, 4=src,tag original value given at command line.  */
  const char *option_help; /**< @brief Option: 1=ANY,ANY, 2=src,ANY, 3=ANY,tag, 4=src,tag help description.  */
  int procs_flag;	/**< @brief use processes instead of threads! (default=off).  */
  const char *procs_help; /**< @brief use processes instead of threads! help description.  */
  int latency_flag;	/**< @brief measure latency instead of message rate (default=off).  */
  const char *latency_help; /**< @brief measure latency instead of message rate help description.  */
  
  unsigned int help_given ;	/**< @brief Whether help was given.  */
  unsigned int version_given ;	/**< @brief Whether version was given.  */
  unsigned int pattern_given ;	/**< @brief Whether pattern was given.  */
  unsigned int threads_given ;	/**< @brief Whether threads was given.  */
  unsigned int messages_given ;	/**< @brief Whether messages was given.  */
  unsigned int reps_given ;	/**< @brief Whether reps was given.  */
  unsigned int hostname_given ;	/**< @brief Whether hostname was given.  */
  unsigned int nonblocking_given ;	/**< @brief Whether nonblocking was given.  */
  unsigned int option_given ;	/**< @brief Whether option was given.  */
  unsigned int procs_given ;	/**< @brief Whether procs was given.  */
  unsigned int latency_given ;	/**< @brief Whether latency was given.  */

} ;

/** @brief The additional parameters to pass to parser functions */
struct ptrn_mprobe_parser_params
{
  int override; /**< @brief whether to override possibly already present options (default 0) */
  int initialize; /**< @brief whether to initialize the option structure ptrn_mprobe_cmd_struct (default 1) */
  int check_required; /**< @brief whether to check that all required options were provided (default 1) */
  int check_ambiguity; /**< @brief whether to check for options already specified in the option structure ptrn_mprobe_cmd_struct (default 0) */
  int print_errors; /**< @brief whether getopt_long should print an error message for a bad option (default 1) */
} ;

/** @brief the purpose string of the program */
extern const char *ptrn_mprobe_cmd_struct_purpose;
/** @brief the usage string of the program */
extern const char *ptrn_mprobe_cmd_struct_usage;
/** @brief all the lines making the help output */
extern const char *ptrn_mprobe_cmd_struct_help[];

/**
 * The command line parser
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int ptrn_mprobe_parser (int argc, char * const *argv,
  struct ptrn_mprobe_cmd_struct *args_info);

/**
 * The command line parser (version with additional parameters - deprecated)
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @param override whether to override possibly already present options
 * @param initialize whether to initialize the option structure my_args_info
 * @param check_required whether to check that all required options were provided
 * @return 0 if everything went fine, NON 0 if an error took place
 * @deprecated use ptrn_mprobe_parser_ext() instead
 */
int ptrn_mprobe_parser2 (int argc, char * const *argv,
  struct ptrn_mprobe_cmd_struct *args_info,
  int override, int initialize, int check_required);

/**
 * The command line parser (version with additional parameters)
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @param params additional parameters for the parser
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int ptrn_mprobe_parser_ext (int argc, char * const *argv,
  struct ptrn_mprobe_cmd_struct *args_info,
  struct ptrn_mprobe_parser_params *params);

/**
 * Save the contents of the option struct into an already open FILE stream.
 * @param outfile the stream where to dump options
 * @param args_info the option struct to dump
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int ptrn_mprobe_parser_dump(FILE *outfile,
  struct ptrn_mprobe_cmd_struct *args_info);

/**
 * Save the contents of the option struct into a (text) file.
 * This file can be read by the config file parser (if generated by gengetopt)
 * @param filename the file where to save
 * @param args_info the option struct to save
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int ptrn_mprobe_parser_file_save(const char *filename,
  struct ptrn_mprobe_cmd_struct *args_info);

/**
 * Print the help
 */
void ptrn_mprobe_parser_print_help(void);
/**
 * Print the version
 */
void ptrn_mprobe_parser_print_version(void);

/**
 * Initializes all the fields a ptrn_mprobe_parser_params structure 
 * to their default values
 * @param params the structure to initialize
 */
void ptrn_mprobe_parser_params_init(struct ptrn_mprobe_parser_params *params);

/**
 * Allocates dynamically a ptrn_mprobe_parser_params structure and initializes
 * all its fields to their default values
 * @return the created and initialized ptrn_mprobe_parser_params structure
 */
struct ptrn_mprobe_parser_params *ptrn_mprobe_parser_params_create(void);

/**
 * Initializes the passed ptrn_mprobe_cmd_struct structure's fields
 * (also set default values for options that have a default)
 * @param args_info the structure to initialize
 */
void ptrn_mprobe_parser_init (struct ptrn_mprobe_cmd_struct *args_info);
/**
 * Deallocates the string fields of the ptrn_mprobe_cmd_struct structure
 * (but does not deallocate the structure itself)
 * @param args_info the structure to deallocate
 */
void ptrn_mprobe_parser_free (struct ptrn_mprobe_cmd_struct *args_info);

/**
 * The string parser (interprets the passed string as a command line)
 * @param cmdline the command line stirng
 * @param args_info the structure where option information will be stored
 * @param prog_name the name of the program that will be used to print
 *   possible errors
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int ptrn_mprobe_parser_string (const char *cmdline, struct ptrn_mprobe_cmd_struct *args_info,
  const char *prog_name);
/**
 * The string parser (version with additional parameters - deprecated)
 * @param cmdline the command line stirng
 * @param args_info the structure where option information will be stored
 * @param prog_name the name of the program that will be used to print
 *   possible errors
 * @param override whether to override possibly already present options
 * @param initialize whether to initialize the option structure my_args_info
 * @param check_required whether to check that all required options were provided
 * @return 0 if everything went fine, NON 0 if an error took place
 * @deprecated use ptrn_mprobe_parser_string_ext() instead
 */
int ptrn_mprobe_parser_string2 (const char *cmdline, struct ptrn_mprobe_cmd_struct *args_info,
  const char *prog_name,
  int override, int initialize, int check_required);
/**
 * The string parser (version with additional parameters)
 * @param cmdline the command line stirng
 * @param args_info the structure where option information will be stored
 * @param prog_name the name of the program that will be used to print
 *   possible errors
 * @param params additional parameters for the parser
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int ptrn_mprobe_parser_string_ext (const char *cmdline, struct ptrn_mprobe_cmd_struct *args_info,
  const char *prog_name,
  struct ptrn_mprobe_parser_params *params);

/**
 * Checks that all the required options were specified
 * @param args_info the structure to check
 * @param prog_name the name of the program that will be used to print
 *   possible errors
 * @return
 */
int ptrn_mprobe_parser_required (struct ptrn_mprobe_cmd_struct *args_info,
  const char *prog_name);


#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* PTRN_MPROBE_CMDLINE_H */
