/*
  File autogenerated by gengetopt version 2.22.2
  generated with the following command:
  gengetopt -S -i ptrn_noise_cmdline.ggo -F ptrn_noise_cmdline -f ptrn_noise_parser -a ptrn_noise_cmd_struct 

  The developers of gengetopt consider the fixed text that goes in all
  gengetopt output files to be in the public domain:
  we make no copyright claims on it.
*/

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifndef FIX_UNUSED
#define FIX_UNUSED(X) (void) (X) /* avoid warnings for unused params */
#endif

#include "getopt.h"

#include "ptrn_noise_cmdline.h"

const char *ptrn_noise_cmd_struct_purpose = "";

const char *ptrn_noise_cmd_struct_usage = "Usage: noise-bench [OPTIONS]...";

const char *ptrn_noise_cmd_struct_description = "";

const char *ptrn_noise_cmd_struct_help[] = {
  "  -h, --help           Print help and exit",
  "  -V, --version        Print version and exit",
  "  -x, --pattern        Pattern argument",
  "  -e, --method=STRING  Selects the benchmark to use  (possible values=\"fwq\", \n                         \"ftq\", \"selfish\" default=`selfish')",
  "  -s, --samples=INT    Number of samples the benchmark should obtain  \n                         (default=`100000')",
  "  -d, --duration=INT   Ideal duration of computation phase in microseconds  \n                         (default=`1000')",
  "  -t, --threshold=INT  Threshold value which governs how long a detour cycle \n                         has to be (in per cent of the minimal cycle length) to \n                         be recorded by the detour-benchmark  (default=`900')",
  "  -w, --write-all      Each rank writes the trace file  (default=off)",
    0
};

typedef enum {ARG_NO
  , ARG_FLAG
  , ARG_STRING
  , ARG_INT
} ptrn_noise_parser_arg_type;

static
void clear_given (struct ptrn_noise_cmd_struct *args_info);
static
void clear_args (struct ptrn_noise_cmd_struct *args_info);

static int
ptrn_noise_parser_internal (int argc, char * const *argv, struct ptrn_noise_cmd_struct *args_info,
                        struct ptrn_noise_parser_params *params, const char *additional_error);

struct line_list
{
  char * string_arg;
  struct line_list * next;
};

static struct line_list *cmd_line_list = 0;
static struct line_list *cmd_line_list_tmp = 0;

static void
free_cmd_list(void)
{
  /* free the list of a previous call */
  if (cmd_line_list)
    {
      while (cmd_line_list) {
        cmd_line_list_tmp = cmd_line_list;
        cmd_line_list = cmd_line_list->next;
        free (cmd_line_list_tmp->string_arg);
        free (cmd_line_list_tmp);
      }
    }
}


const char *ptrn_noise_parser_method_values[] = {"fwq", "ftq", "selfish", 0}; /*< Possible values for method. */

static char *
gengetopt_strdup (const char *s);

static
void clear_given (struct ptrn_noise_cmd_struct *args_info)
{
  args_info->help_given = 0 ;
  args_info->version_given = 0 ;
  args_info->pattern_given = 0 ;
  args_info->method_given = 0 ;
  args_info->samples_given = 0 ;
  args_info->duration_given = 0 ;
  args_info->threshold_given = 0 ;
  args_info->write_all_given = 0 ;
}

static
void clear_args (struct ptrn_noise_cmd_struct *args_info)
{
  FIX_UNUSED (args_info);
  args_info->method_arg = gengetopt_strdup ("selfish");
  args_info->method_orig = NULL;
  args_info->samples_arg = 100000;
  args_info->samples_orig = NULL;
  args_info->duration_arg = 1000;
  args_info->duration_orig = NULL;
  args_info->threshold_arg = 900;
  args_info->threshold_orig = NULL;
  args_info->write_all_flag = 0;
  
}

static
void init_args_info(struct ptrn_noise_cmd_struct *args_info)
{


  args_info->help_help = ptrn_noise_cmd_struct_help[0] ;
  args_info->version_help = ptrn_noise_cmd_struct_help[1] ;
  args_info->pattern_help = ptrn_noise_cmd_struct_help[2] ;
  args_info->method_help = ptrn_noise_cmd_struct_help[3] ;
  args_info->samples_help = ptrn_noise_cmd_struct_help[4] ;
  args_info->duration_help = ptrn_noise_cmd_struct_help[5] ;
  args_info->threshold_help = ptrn_noise_cmd_struct_help[6] ;
  args_info->write_all_help = ptrn_noise_cmd_struct_help[7] ;
  
}

void
ptrn_noise_parser_print_version (void)
{
  printf ("%s %s\n",
     (strlen(PTRN_NOISE_PARSER_PACKAGE_NAME) ? PTRN_NOISE_PARSER_PACKAGE_NAME : PTRN_NOISE_PARSER_PACKAGE),
     PTRN_NOISE_PARSER_VERSION);
}

static void print_help_common(void) {
  ptrn_noise_parser_print_version ();

  if (strlen(ptrn_noise_cmd_struct_purpose) > 0)
    printf("\n%s\n", ptrn_noise_cmd_struct_purpose);

  if (strlen(ptrn_noise_cmd_struct_usage) > 0)
    printf("\n%s\n", ptrn_noise_cmd_struct_usage);

  printf("\n");

  if (strlen(ptrn_noise_cmd_struct_description) > 0)
    printf("%s\n\n", ptrn_noise_cmd_struct_description);
}

void
ptrn_noise_parser_print_help (void)
{
  int i = 0;
  print_help_common();
  while (ptrn_noise_cmd_struct_help[i])
    printf("%s\n", ptrn_noise_cmd_struct_help[i++]);
}

void
ptrn_noise_parser_init (struct ptrn_noise_cmd_struct *args_info)
{
  clear_given (args_info);
  clear_args (args_info);
  init_args_info (args_info);
}

void
ptrn_noise_parser_params_init(struct ptrn_noise_parser_params *params)
{
  if (params)
    { 
      params->override = 0;
      params->initialize = 1;
      params->check_required = 1;
      params->check_ambiguity = 0;
      params->print_errors = 1;
    }
}

struct ptrn_noise_parser_params *
ptrn_noise_parser_params_create(void)
{
  struct ptrn_noise_parser_params *params = 
    (struct ptrn_noise_parser_params *)malloc(sizeof(struct ptrn_noise_parser_params));
  ptrn_noise_parser_params_init(params);  
  return params;
}

static void
free_string_field (char **s)
{
  if (*s)
    {
      free (*s);
      *s = 0;
    }
}


static void
ptrn_noise_parser_release (struct ptrn_noise_cmd_struct *args_info)
{

  free_string_field (&(args_info->method_arg));
  free_string_field (&(args_info->method_orig));
  free_string_field (&(args_info->samples_orig));
  free_string_field (&(args_info->duration_orig));
  free_string_field (&(args_info->threshold_orig));
  
  

  clear_given (args_info);
}

/**
 * @param val the value to check
 * @param values the possible values
 * @return the index of the matched value:
 * -1 if no value matched,
 * -2 if more than one value has matched
 */
static int
check_possible_values(const char *val, const char *values[])
{
  int i, found, last;
  size_t len;

  if (!val)   /* otherwise strlen() crashes below */
    return -1; /* -1 means no argument for the option */

  found = last = 0;

  for (i = 0, len = strlen(val); values[i]; ++i)
    {
      if (strncmp(val, values[i], len) == 0)
        {
          ++found;
          last = i;
          if (strlen(values[i]) == len)
            return i; /* exact macth no need to check more */
        }
    }

  if (found == 1) /* one match: OK */
    return last;

  return (found ? -2 : -1); /* return many values or none matched */
}


static void
write_into_file(FILE *outfile, const char *opt, const char *arg, const char *values[])
{
  int found = -1;
  if (arg) {
    if (values) {
      found = check_possible_values(arg, values);      
    }
    if (found >= 0)
      fprintf(outfile, "%s=\"%s\" # %s\n", opt, arg, values[found]);
    else
      fprintf(outfile, "%s=\"%s\"\n", opt, arg);
  } else {
    fprintf(outfile, "%s\n", opt);
  }
}


int
ptrn_noise_parser_dump(FILE *outfile, struct ptrn_noise_cmd_struct *args_info)
{
  int i = 0;

  if (!outfile)
    {
      fprintf (stderr, "%s: cannot dump options to stream\n", PTRN_NOISE_PARSER_PACKAGE);
      return EXIT_FAILURE;
    }

  if (args_info->help_given)
    write_into_file(outfile, "help", 0, 0 );
  if (args_info->version_given)
    write_into_file(outfile, "version", 0, 0 );
  if (args_info->pattern_given)
    write_into_file(outfile, "pattern", 0, 0 );
  if (args_info->method_given)
    write_into_file(outfile, "method", args_info->method_orig, ptrn_noise_parser_method_values);
  if (args_info->samples_given)
    write_into_file(outfile, "samples", args_info->samples_orig, 0);
  if (args_info->duration_given)
    write_into_file(outfile, "duration", args_info->duration_orig, 0);
  if (args_info->threshold_given)
    write_into_file(outfile, "threshold", args_info->threshold_orig, 0);
  if (args_info->write_all_given)
    write_into_file(outfile, "write-all", 0, 0 );
  

  i = EXIT_SUCCESS;
  return i;
}

int
ptrn_noise_parser_file_save(const char *filename, struct ptrn_noise_cmd_struct *args_info)
{
  FILE *outfile;
  int i = 0;

  outfile = fopen(filename, "w");

  if (!outfile)
    {
      fprintf (stderr, "%s: cannot open file for writing: %s\n", PTRN_NOISE_PARSER_PACKAGE, filename);
      return EXIT_FAILURE;
    }

  i = ptrn_noise_parser_dump(outfile, args_info);
  fclose (outfile);

  return i;
}

void
ptrn_noise_parser_free (struct ptrn_noise_cmd_struct *args_info)
{
  ptrn_noise_parser_release (args_info);
}

/** @brief replacement of strdup, which is not standard */
char *
gengetopt_strdup (const char *s)
{
  char *result = 0;
  if (!s)
    return result;

  result = (char*)malloc(strlen(s) + 1);
  if (result == (char*)0)
    return (char*)0;
  strcpy(result, s);
  return result;
}

int
ptrn_noise_parser (int argc, char * const *argv, struct ptrn_noise_cmd_struct *args_info)
{
  return ptrn_noise_parser2 (argc, argv, args_info, 0, 1, 1);
}

int
ptrn_noise_parser_ext (int argc, char * const *argv, struct ptrn_noise_cmd_struct *args_info,
                   struct ptrn_noise_parser_params *params)
{
  int result;
  result = ptrn_noise_parser_internal (argc, argv, args_info, params, 0);

  if (result == EXIT_FAILURE)
    {
      ptrn_noise_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
ptrn_noise_parser2 (int argc, char * const *argv, struct ptrn_noise_cmd_struct *args_info, int override, int initialize, int check_required)
{
  int result;
  struct ptrn_noise_parser_params params;
  
  params.override = override;
  params.initialize = initialize;
  params.check_required = check_required;
  params.check_ambiguity = 0;
  params.print_errors = 1;

  result = ptrn_noise_parser_internal (argc, argv, args_info, &params, 0);

  if (result == EXIT_FAILURE)
    {
      ptrn_noise_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
ptrn_noise_parser_required (struct ptrn_noise_cmd_struct *args_info, const char *prog_name)
{
  FIX_UNUSED (args_info);
  FIX_UNUSED (prog_name);
  return EXIT_SUCCESS;
}


static char *package_name = 0;

/**
 * @brief updates an option
 * @param field the generic pointer to the field to update
 * @param orig_field the pointer to the orig field
 * @param field_given the pointer to the number of occurrence of this option
 * @param prev_given the pointer to the number of occurrence already seen
 * @param value the argument for this option (if null no arg was specified)
 * @param possible_values the possible values for this option (if specified)
 * @param default_value the default value (in case the option only accepts fixed values)
 * @param arg_type the type of this option
 * @param check_ambiguity @see ptrn_noise_parser_params.check_ambiguity
 * @param override @see ptrn_noise_parser_params.override
 * @param no_free whether to free a possible previous value
 * @param multiple_option whether this is a multiple option
 * @param long_opt the corresponding long option
 * @param short_opt the corresponding short option (or '-' if none)
 * @param additional_error possible further error specification
 */
static
int update_arg(void *field, char **orig_field,
               unsigned int *field_given, unsigned int *prev_given, 
               char *value, const char *possible_values[],
               const char *default_value,
               ptrn_noise_parser_arg_type arg_type,
               int check_ambiguity, int override,
               int no_free, int multiple_option,
               const char *long_opt, char short_opt,
               const char *additional_error)
{
  FIX_UNUSED (field);
  char *stop_char = 0;
  const char *val = value;
  int found;
  char **string_field;

  stop_char = 0;
  found = 0;

  if (!multiple_option && prev_given && (*prev_given || (check_ambiguity && *field_given)))
    {
      if (short_opt != '-')
        fprintf (stderr, "%s: `--%s' (`-%c') option given more than once%s\n", 
               package_name, long_opt, short_opt,
               (additional_error ? additional_error : ""));
      else
        fprintf (stderr, "%s: `--%s' option given more than once%s\n", 
               package_name, long_opt,
               (additional_error ? additional_error : ""));
      return 1; /* failure */
    }

  if (possible_values && (found = check_possible_values((value ? value : default_value), possible_values)) < 0)
    {
      if (short_opt != '-')
        fprintf (stderr, "%s: %s argument, \"%s\", for option `--%s' (`-%c')%s\n", 
          package_name, (found == -2) ? "ambiguous" : "invalid", value, long_opt, short_opt,
          (additional_error ? additional_error : ""));
      else
        fprintf (stderr, "%s: %s argument, \"%s\", for option `--%s'%s\n", 
          package_name, (found == -2) ? "ambiguous" : "invalid", value, long_opt,
          (additional_error ? additional_error : ""));
      return 1; /* failure */
    }
    
  if (field_given && *field_given && ! override)
    return 0;
  if (prev_given)
    (*prev_given)++;
  if (field_given)
    (*field_given)++;
  if (possible_values)
    val = possible_values[found];

  switch(arg_type) {
  case ARG_FLAG:
    *((int *)field) = !*((int *)field);
    break;
  case ARG_INT:
    if (val) *((int *)field) = strtol (val, &stop_char, 0);
    break;
  case ARG_STRING:
    if (val) {
      string_field = (char **)field;
      if (!no_free && *string_field)
        free (*string_field); /* free previous string */
      *string_field = gengetopt_strdup (val);
    }
    break;
  default:
    break;
  };

  /* check numeric conversion */
  switch(arg_type) {
  case ARG_INT:
    if (val && !(stop_char && *stop_char == '\0')) {
      fprintf(stderr, "%s: invalid numeric value: %s\n", package_name, val);
      return 1; /* failure */
    }
    break;
  default:
    ;
  };

  /* store the original value */
  switch(arg_type) {
  case ARG_NO:
  case ARG_FLAG:
    break;
  default:
    if (value && orig_field) {
      if (no_free) {
        *orig_field = value;
      } else {
        if (*orig_field)
          free (*orig_field); /* free previous string */
        *orig_field = gengetopt_strdup (value);
      }
    }
  };

  return 0; /* OK */
}


int
ptrn_noise_parser_internal (
  int argc, char * const *argv, struct ptrn_noise_cmd_struct *args_info,
                        struct ptrn_noise_parser_params *params, const char *additional_error)
{
  int c;	/* Character of the parsed option.  */

  int error = 0;
  struct ptrn_noise_cmd_struct local_args_info;
  
  int override;
  int initialize;
  int check_required;
  int check_ambiguity;
  
  package_name = argv[0];
  
  override = params->override;
  initialize = params->initialize;
  check_required = params->check_required;
  check_ambiguity = params->check_ambiguity;

  if (initialize)
    ptrn_noise_parser_init (args_info);

  ptrn_noise_parser_init (&local_args_info);

  optarg = 0;
  optind = 0;
  opterr = params->print_errors;
  optopt = '?';

  while (1)
    {
      int option_index = 0;

      static struct option long_options[] = {
        { "help",	0, NULL, 'h' },
        { "version",	0, NULL, 'V' },
        { "pattern",	0, NULL, 'x' },
        { "method",	1, NULL, 'e' },
        { "samples",	1, NULL, 's' },
        { "duration",	1, NULL, 'd' },
        { "threshold",	1, NULL, 't' },
        { "write-all",	0, NULL, 'w' },
        { 0,  0, 0, 0 }
      };

      c = getopt_long (argc, argv, "hVxe:s:d:t:w", long_options, &option_index);

      if (c == -1) break;	/* Exit from `while (1)' loop.  */

      switch (c)
        {
        case 'h':	/* Print help and exit.  */
          ptrn_noise_parser_print_help ();
          ptrn_noise_parser_free (&local_args_info);
          exit (EXIT_SUCCESS);

        case 'V':	/* Print version and exit.  */
          ptrn_noise_parser_print_version ();
          ptrn_noise_parser_free (&local_args_info);
          exit (EXIT_SUCCESS);

        case 'x':	/* Pattern argument.  */
        
        
          if (update_arg( 0 , 
               0 , &(args_info->pattern_given),
              &(local_args_info.pattern_given), optarg, 0, 0, ARG_NO,
              check_ambiguity, override, 0, 0,
              "pattern", 'x',
              additional_error))
            goto failure;
        
          break;
        case 'e':	/* Selects the benchmark to use.  */
        
        
          if (update_arg( (void *)&(args_info->method_arg), 
               &(args_info->method_orig), &(args_info->method_given),
              &(local_args_info.method_given), optarg, ptrn_noise_parser_method_values, "selfish", ARG_STRING,
              check_ambiguity, override, 0, 0,
              "method", 'e',
              additional_error))
            goto failure;
        
          break;
        case 's':	/* Number of samples the benchmark should obtain.  */
        
        
          if (update_arg( (void *)&(args_info->samples_arg), 
               &(args_info->samples_orig), &(args_info->samples_given),
              &(local_args_info.samples_given), optarg, 0, "100000", ARG_INT,
              check_ambiguity, override, 0, 0,
              "samples", 's',
              additional_error))
            goto failure;
        
          break;
        case 'd':	/* Ideal duration of computation phase in microseconds.  */
        
        
          if (update_arg( (void *)&(args_info->duration_arg), 
               &(args_info->duration_orig), &(args_info->duration_given),
              &(local_args_info.duration_given), optarg, 0, "1000", ARG_INT,
              check_ambiguity, override, 0, 0,
              "duration", 'd',
              additional_error))
            goto failure;
        
          break;
        case 't':	/* Threshold value which governs how long a detour cycle has to be (in per cent of the minimal cycle length) to be recorded by the detour-benchmark.  */
        
        
          if (update_arg( (void *)&(args_info->threshold_arg), 
               &(args_info->threshold_orig), &(args_info->threshold_given),
              &(local_args_info.threshold_given), optarg, 0, "900", ARG_INT,
              check_ambiguity, override, 0, 0,
              "threshold", 't',
              additional_error))
            goto failure;
        
          break;
        case 'w':	/* Each rank writes the trace file.  */
        
        
          if (update_arg((void *)&(args_info->write_all_flag), 0, &(args_info->write_all_given),
              &(local_args_info.write_all_given), optarg, 0, 0, ARG_FLAG,
              check_ambiguity, override, 1, 0, "write-all", 'w',
              additional_error))
            goto failure;
        
          break;

        case 0:	/* Long option with no short option */
        case '?':	/* Invalid option.  */
          /* `getopt_long' already printed an error message.  */
          goto failure;

        default:	/* bug: option not considered.  */
          fprintf (stderr, "%s: option unknown: %c%s\n", PTRN_NOISE_PARSER_PACKAGE, c, (additional_error ? additional_error : ""));
          abort ();
        } /* switch */
    } /* while */




  ptrn_noise_parser_release (&local_args_info);

  if ( error )
    return (EXIT_FAILURE);

  return 0;

failure:
  
  ptrn_noise_parser_release (&local_args_info);
  return (EXIT_FAILURE);
}

static unsigned int
ptrn_noise_parser_create_argv(const char *cmdline_, char ***argv_ptr, const char *prog_name)
{
  char *cmdline, *p;
  size_t n = 0, j;
  int i;

  if (prog_name) {
    cmd_line_list_tmp = (struct line_list *) malloc (sizeof (struct line_list));
    cmd_line_list_tmp->next = cmd_line_list;
    cmd_line_list = cmd_line_list_tmp;
    cmd_line_list->string_arg = gengetopt_strdup (prog_name);

    ++n;
  }

  cmdline = gengetopt_strdup(cmdline_);
  p = cmdline;

  while (p && strlen(p))
    {
      j = strcspn(p, " \t");
      ++n;
      if (j && j < strlen(p))
        {
          p[j] = '\0';

          cmd_line_list_tmp = (struct line_list *) malloc (sizeof (struct line_list));
          cmd_line_list_tmp->next = cmd_line_list;
          cmd_line_list = cmd_line_list_tmp;
          cmd_line_list->string_arg = gengetopt_strdup (p);

          p += (j+1);
          p += strspn(p, " \t");
        }
      else
        {
          cmd_line_list_tmp = (struct line_list *) malloc (sizeof (struct line_list));
          cmd_line_list_tmp->next = cmd_line_list;
          cmd_line_list = cmd_line_list_tmp;
          cmd_line_list->string_arg = gengetopt_strdup (p);

          break;
        }
    }

  *argv_ptr = (char **) malloc((n + 1) * sizeof(char *));
  cmd_line_list_tmp = cmd_line_list;
  for (i = (n-1); i >= 0; --i)
    {
      (*argv_ptr)[i] = cmd_line_list_tmp->string_arg;
      cmd_line_list_tmp = cmd_line_list_tmp->next;
    }

  (*argv_ptr)[n] = 0;

  free(cmdline);
  return n;
}

int
ptrn_noise_parser_string(const char *cmdline, struct ptrn_noise_cmd_struct *args_info, const char *prog_name)
{
  return ptrn_noise_parser_string2(cmdline, args_info, prog_name, 0, 1, 1);
}

int
ptrn_noise_parser_string2(const char *cmdline, struct ptrn_noise_cmd_struct *args_info, const char *prog_name,
    int override, int initialize, int check_required)
{
  struct ptrn_noise_parser_params params;

  params.override = override;
  params.initialize = initialize;
  params.check_required = check_required;
  params.check_ambiguity = 0;
  params.print_errors = 1;

  return ptrn_noise_parser_string_ext(cmdline, args_info, prog_name, &params);
}

int
ptrn_noise_parser_string_ext(const char *cmdline, struct ptrn_noise_cmd_struct *args_info, const char *prog_name,
    struct ptrn_noise_parser_params *params)
{
  char **argv_ptr = 0;
  int result;
  unsigned int argc;
  
  argc = ptrn_noise_parser_create_argv(cmdline, &argv_ptr, prog_name);
  
  result =
    ptrn_noise_parser_internal (argc, argv_ptr, args_info, params, 0);
  
  if (argv_ptr)
    {
      free (argv_ptr);
    }

  free_cmd_list();
  
  if (result == EXIT_FAILURE)
    {
      ptrn_noise_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

